let $$ = require('cdev/debug')({ debug: 'cache', path: module.id, prefix: '[isg.xpert.archive - import]' });
$$.md = require('/agorum/roi/customers/cdev.ncore/js/utils/md')($$);
$$.objects = require('common/objects');

let metadata = require('common/metadata');
let transaction = require('common/transaction');

let utils = require('./idx-utils');
let archive = require('./archive');

function processTriggerFile(obj, parms) {

  let logAndThrow = (msg) => { $$.log(msg); throw new Error(msg); };

  $$.debug('processTriggerFile', obj, parms);

  let item = $$.objects.tryFind(obj);
  if (!item) logAndThrow('item [{0}] not found'.format(obj));
  let folder = item.firstParent;

  $$.log('found trigger [{0}]'.format(item.name));

  if (!folder) logAndThrow('folder for item [{0}] not found'.format(obj));
  let buffer = $$.objects.tryFind(parms.buffer);
  if (!buffer) logAndThrow('buffer [{0}] not found'.format(parms.buffer));
  let errors = $$.objects.tryFind(parms.errors);
  if (!errors) throw new Error('errors [{0}] not found'.format(parms.errors));
  let ignore = $$.objects.tryFind(parms.ignore);
  if (!ignore) logAndThrow('ignore [{0}] not found'.format(parms.ignore));

  let idx = null,
    content = null,
    meta = null,
    path = utils.splitPath(item.name),
    processError = null,
    processCode = '0',
    idxMoved = false,
    imagesMoved = false;

  $$.objects.unlink(item); // unlink ok file to prevent reprocessing

  try {

    // find idx file based on filename from ok file
    idx = folder.getItem(path.name + '.idx');
    if (!idx) throw new Error('idx file for [{0}] not found'.format(item.name));
    $$.log('found index [{0}]'.format(idx.name));

    // process the idx file and save metadata to idx file for debugging
    content = utils.convertContent(idx.contentStream, utils.IDX_CHARSET);
    meta = utils.convertToJSON(content, utils.PREFIX);

    // save metadata to idx file for debugging
    $$.md.save(idx, meta);

    // check processCode and throw error if not 0
    processCode = meta[utils.PREFIX + 'processCode'];
    if (processCode !== '0')
      throw new Error('skipping [{0}] because of invalid processCode [{1}]'.format(idx.name, processCode));

    // check for image files and throw error if none is found
    $$.debug('using document base path [{0}]'.format(path.base), meta);
    if (!meta[utils.PREFIX + 'images'] || meta[utils.PREFIX + 'images'].length === 0)
      throw new Error('no image files found for [{0}]'.format(idx.name));

    // always try to move images from import to buffer folder
    utils.moveImages(idx, meta, [buffer], true);
    imagesMoved = true;

    // move idx to buffer and run archive process
    $$.objects.unlink(idx);
    $$.objects.link(idx, buffer);
    $$.log('moved [{0}] to [{1}]'.format(idx.name, buffer.name));
    idxMoved = true;
    
    // check for processError from convertToJSON and throw error if not null
    if (meta[utils.PREFIX + 'processError'])
      throw new Error(meta[utils.PREFIX + 'processError']);

  } catch (error) {
    processError = error.message;
    // log error and move all files to error folder
    let label = processCode === '0' ? 'ERROR' : 'IGNORE';
    let target = processCode === '0' ? errors : ignore;
    $$.debug(label, error);
    $$.log(label + ' ' + error.message);
    let pdf = folder.getItem(path.base + '.pdf');
    if (pdf) {
      // process stale pdf file
      $$.objects.unlink(pdf);
      $$.objects.link(pdf, target);
      $$.log('moved [{0}] to [{1}]'.format(pdf.name, target.name));
    }
    if (idx) {
      meta[utils.PREFIX + 'processError'] = error.message;
      // save metadata to idx file for debugging
      $$.md.save(idx, meta);
      if (!idxMoved) {
        $$.objects.unlink(idx);
        $$.objects.link(idx, target);
        $$.log('moved [{0}] to [{1}]'.format(idx.name, target.name));
      }
      if (!imagesMoved) {
        try {
          utils.moveImages(idx, meta, [target], true);
        } catch (error) {
          $$.debug('ERROR', error);
          $$.log('ERROR ' + error.message);
        }
      }
    }
  }
  if (!processError) {
    // run archive process in transaction
    transaction(() => {
      archive.processDocument(idx, meta);
    });
  } else {
    $$.debug('skipping', obj, processError);
    $$.log('skipping [{0}] because of [{1}]'.format(obj.name, processError));
  }
}

module.exports = (obj, parameters) => {
  return processTriggerFile(obj, parameters);
};

